/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelPick;
import vazkii.botania.common.item.relic.ItemThorRing;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemTerraPick
extends ItemManasteelPick
implements ISequentialBreaker {
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_MANA = "mana";
    private static final String TAG_TIPPED = "tipped";
    private static final int MAX_MANA = Integer.MAX_VALUE;
    private static final int MANA_PER_DAMAGE = 100;
    public static final int[] LEVELS = new int[]{0, 10000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] CREATIVE_MANA = new int[]{9999, 999999, 9999999, 99999999, 999999999, 0x7FFFFFFE};

    public ItemTerraPick(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props, -2.8f);
    }

    public void m_6787_(@Nonnull CreativeModeTab tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.m_41389_(tab)) {
            for (int mana : CREATIVE_MANA) {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemTerraPick.setMana(stack, mana);
                list.add((Object)stack);
            }
            ItemStack stack = new ItemStack((ItemLike)this);
            ItemTerraPick.setMana(stack, CREATIVE_MANA[1]);
            ItemTerraPick.setTipped(stack);
            list.add((Object)stack);
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        TranslatableComponent rank = new TranslatableComponent("botania.rank" + ItemTerraPick.getLevel(stack));
        TranslatableComponent rankFormat = new TranslatableComponent("botaniamisc.toolRank", new Object[]{rank});
        stacks.add((Component)rankFormat);
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        if (manaItem != null && manaItem.getMana() == Integer.MAX_VALUE) {
            stacks.add((Component)new TranslatableComponent("botaniamisc.getALife").m_130940_(ChatFormatting.RED));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && player.m_6144_() && !player.m_21206_().m_41619_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        int level = ItemTerraPick.getLevel(stack);
        if (level != 0) {
            this.setEnabled(stack, !ItemTerraPick.isEnabled(stack));
            if (!world.f_46443_) {
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.terraPickMode, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        if (player == null) {
            return super.m_6225_(ctx);
        }
        if (ctx.m_43724_() == InteractionHand.MAIN_HAND && !player.m_21206_().m_41619_()) {
            return InteractionResult.PASS;
        }
        return player.m_6144_() ? super.m_6225_(ctx) : InteractionResult.PASS;
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (ItemTerraPick.isEnabled(stack)) {
            int level = ItemTerraPick.getLevel(stack);
            if (level == 0) {
                this.setEnabled(stack, false);
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.f_20911_) {
                    IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
                    manaItem.addMana(-level);
                }
            }
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        int level = ItemTerraPick.getLevel(stack);
        int max = LEVELS[Math.min(LEVELS.length - 1, level + 1)];
        int curr = ItemTerraPick.getMana_(stack);
        float percent = level == 0 ? 0.0f : (float)curr / (float)max;
        return Optional.of(new ManaBarTooltip(percent, level));
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        BlockHitResult raycast = ToolCommons.raytraceFromEntity((Entity)player, 10.0, false);
        if (!player.f_19853_.f_46443_ && raycast.m_6662_() == HitResult.Type.BLOCK) {
            Direction face = raycast.m_82434_();
            this.breakOtherBlock(player, stack, pos, pos, face);
            if (player.m_36341_()) {
                BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
            }
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (!ItemTerraPick.isEnabled(stack)) {
            return;
        }
        Level world = player.f_19853_;
        BlockState targetState = world.m_8055_(pos);
        if (stack.m_41691_(targetState) <= 1.0f && !targetState.m_204336_(BlockTags.f_144283_)) {
            return;
        }
        if (world.m_46859_(pos)) {
            return;
        }
        boolean thor = !ItemThorRing.getThorRing(player).m_41619_();
        boolean doX = thor || side.m_122429_() == 0;
        boolean doY = thor || side.m_122430_() == 0;
        boolean doZ = thor || side.m_122431_() == 0;
        int origLevel = ItemTerraPick.getLevel(stack);
        int level = origLevel + (thor ? 1 : 0);
        if (ItemTemperanceStone.hasTemperanceActive(player) && level > 2) {
            level = 2;
        }
        int range = level - 1;
        int rangeY = Math.max(1, range);
        if (range == 0 && level != 1) {
            return;
        }
        Vec3i beginDiff = new Vec3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
        Vec3i endDiff = new Vec3i(doX ? range : 0, doY ? rangeY * 2 - 1 : 0, doZ ? range : 0);
        ToolCommons.removeBlocksInIteration(player, stack, world, pos, beginDiff, endDiff, state -> (!state.m_60834_() || stack.m_41735_(state)) && stack.m_41691_(state) > 1.0f || state.m_204336_(BlockTags.f_144283_));
        if (origLevel == 5) {
            PlayerHelper.grantCriterion((ServerPlayer)player, ResourceLocationHelper.prefix("challenge/rank_ss_pick"), "code_triggered");
        }
    }

    public static boolean isTipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_TIPPED, false);
    }

    public static void setTipped(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_TIPPED, true);
    }

    public static boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_ENABLED, false);
    }

    void setEnabled(ItemStack stack, boolean enabled) {
        ItemNBTHelper.setBoolean(stack, TAG_ENABLED, enabled);
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, mana);
    }

    public static int getMana_(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public static int getLevel(ItemStack stack) {
        int mana = ItemTerraPick.getMana_(stack);
        for (int i = LEVELS.length - 1; i > 0; --i) {
            if (mana < LEVELS[i]) continue;
            return i;
        }
        return 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.reequipAnimation(oldStack, newStack);
    }

    public boolean allowNbtUpdateAnimation(Player player, InteractionHand hand, ItemStack before, ItemStack after) {
        return this.reequipAnimation(before, after);
    }

    private boolean reequipAnimation(ItemStack before, ItemStack after) {
        return !after.m_150930_((Item)this) || ItemTerraPick.isEnabled(before) != ItemTerraPick.isEnabled(after);
    }

    @Nonnull
    public Rarity m_41460_(@Nonnull ItemStack stack) {
        int level = ItemTerraPick.getLevel(stack);
        if (stack.m_41793_()) {
            ++level;
        }
        if (level >= 5) {
            return Rarity.EPIC;
        }
        if (level >= 3) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public static class ManaItem
    implements IManaItem {
        private final ItemStack stack;

        public ManaItem(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public int getMana() {
            return ItemTerraPick.getMana_(this.stack) * this.stack.m_41613_();
        }

        @Override
        public int getMaxMana() {
            return Integer.MAX_VALUE * this.stack.m_41613_();
        }

        @Override
        public void addMana(int mana) {
            ItemTerraPick.setMana(this.stack, Math.min(this.getMana() + mana, this.getMaxMana()) / this.stack.m_41613_());
        }

        @Override
        public boolean canReceiveManaFromPool(BlockEntity pool) {
            return true;
        }

        @Override
        public boolean canReceiveManaFromItem(ItemStack otherStack) {
            return !otherStack.m_204117_(ModTags.Items.TERRA_PICK_BLACKLIST);
        }

        @Override
        public boolean canExportManaToPool(BlockEntity pool) {
            return false;
        }

        @Override
        public boolean canExportManaToItem(ItemStack otherStack) {
            return false;
        }

        @Override
        public boolean isNoExport() {
            return true;
        }
    }
}

